# 外部エディタ
ゲーム内のテキストエディタは通常、このゲームをプレイするのに十分ですが、もちろんVisual Studio Codeのようなより高度なテキストエディタにはかないません。

このゲームはすべてのコードファイルを.pyファイルとして保存するため、Pythonエディタで編集できます。
これは便宜上のものであり、ゲーム内の言語は実際にはPythonではありませんが、PythonのIntelliSenseがまあまあ機能する程度には近いです。
ファイルは[セーブフォルダー](persistent_data_path/Saves)にあります。

各セーブには`__builtins__.py`ファイルも含まれており、これにはIntelliSenseを有効にするためにゲーム内の組み込み関数に一致するPythonの組み込み定義が含まれています。
VS Codeは`__builtins__.py`を自動的に検出できますが、一部のエディタは`from __builtins__ import *`を実行しないと機能しない場合があります。

外部での変更をセーブをリロードせずにゲーム内で確認するには、「ファイルウォッチャー」オプションを有効にする必要があります。外部でファイルを作成または削除した場合は、それらを確認するためにセーブをリロードする必要があります。

## VS Codeの使用
Visual Studio Codeは、The Farmer Was Replacedで使用するのにおすすめのコードエディタです。

[こちら](https://code.visualstudio.com/download)からインストールできます。

ダウンロード後、VS CodeでPython拡張機能をインストールしてください。

それができたら、VS Codeで`.py`ファイルが保存されている[フォルダー](persistent_data_path/Saves)を開きます。`__builtins__.py`ファイルが機能しないため、個々のファイルだけでなく、フォルダー全体を開くようにしてください。

ゲーム内では、「ファイルウォッチャー」オプションがオンになっていることを確認してください。これで、VS Codeで保存するたびに、変更が自動的にゲームに反映されます。

以上です！これでプロ仕様のコードエディタでコードを書くことができます！